using System;
using System.Collections.Generic;
using System.Text;
using VIRP.EFR.BO;
using VIRP.EFR.DAL;

namespace VIRP.EFR.BLL
{
	public static partial class REFERRALManager
	{
		#region Fields
		#endregion

		#region Properties
		#endregion

		#region Methods

		public static REFERRAL GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32? VIRP_ReFerral_ID)
		{
			REFERRAL objReturn = null;
			REFERRALDB objDB = new REFERRALDB();

			objReturn = objDB.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, VIRP_ReFerral_ID);

			return objReturn;
		}

        public static REFERRAL GetItemByReferral(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            REFERRAL objReturn = null;
            REFERRALDB objDB = new REFERRALDB();

            objReturn = objDB.GetItemByReferral(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID);

            return objReturn;
        }

        public static int GetReferralOriginalRecordCount(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            int objReturn = 0;
            REFERRALDB objDB = new REFERRALDB();

            objReturn = objDB.GetReferralOriginalRecordCount(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID);

            return objReturn;
        }

        public static VIRP.CRS.BO.REFERRAL GetDuplicate(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID, string PATIENT_SNUM)
        {
            VIRP.CRS.BO.REFERRAL objReturn = null;
            REFERRALDB objDB = new REFERRALDB();

            objReturn = objDB.GetDuplicate(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID, PATIENT_SNUM);

            return objReturn;
        }

        public static List<REFERRAL> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<REFERRAL> objReturn = null;
			REFERRALDB objDB = new REFERRALDB();

			objReturn = objDB.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);

			return objReturn;
        }

        public static EFRHealthFactorsByReferral GetHealthFactors(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            EFRHealthFactorsByReferral objReturn = null;
            REFERRALDB objDB = new REFERRALDB();

            objReturn = objDB.GetHealthFactors(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID);

            return objReturn;
        }

        public static List<REFERRAL_DETAIL> GetHealthFactorsComplete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            List<REFERRAL_DETAIL> objReturn = null;
            REFERRALDB objDB = new REFERRALDB();

            objReturn = objDB.GetHealthFactorsComplete(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID);

            return objReturn;
        }

        public static List<VIRP.CRS.BO.WKF_CASE_ACTIVITY> GetBioFollowups(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            List<VIRP.CRS.BO.WKF_CASE_ACTIVITY> objReturn = null;
            REFERRALDB objDB = new REFERRALDB();

            objReturn = objDB.GetBioFollowups(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID);

            return objReturn;
        }
         
        public static DateTime? GetReferralDateByPatientId(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID)
        {
            DateTime? objReturn = null;
            REFERRALDB objDB = new REFERRALDB();

            objReturn = objDB.GetReferralDateByPatientId(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID);

            return objReturn;
        }

        public static Int32? Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, REFERRAL objSave)
		{
			Int32? objReturn = 0;
			REFERRALDB objDB = new REFERRALDB();

			objReturn = objDB.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);

			return objReturn;
		}

		public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32? VIRP_ReFerral_ID)
		{
			Boolean objReturn = false;
			REFERRALDB objDB = new REFERRALDB();

			objReturn = objDB.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, VIRP_ReFerral_ID);

			return objReturn;
		}

		public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, REFERRAL objDelete)
		{
			return Delete(CURRENT_USER, CURRENT_REGISTRY_ID, objDelete.VIRP_ReFerral_ID);
		}

        public static List<EfrStatistics> GetEfrCountStatistics(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<EfrStatistics> objReturn = null;
            REFERRALDB objDB = new REFERRALDB();

            objReturn = objDB.GetEfrCountStatistics(CURRENT_USER, CURRENT_REGISTRY_ID);

            return objReturn;
        }

        public static string GetStatusCode(int statusId)
        {
            //Maps the status ID to the status codes in the database
            string statusCode = "";

            switch (statusId)
            {
                case 4:
                    statusCode = "EFR_NEW";
                    break;
                case 5:
                    statusCode = "EFR_OPEN_CASES";
                    break;
                case 6:
                    statusCode = "EFR_CLOSED_CASES";
                    break;
                case 9:
                    statusCode = "EFR_INELIGIBLE";
                    break;
                case 10:
                    statusCode = "EFR_NO ACTION REQUIRED";
                    break;
            }

            return statusCode;
        }

        public static IEnumerable<ReferralsGetListByPatientResult> SelectByPatientId(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            int PATIENT_ID)
        {
            var db = new REFERRALDB();
            List<ReferralsGetListByPatientResult> sortedList = new List<ReferralsGetListByPatientResult>();

            var results = db.SelectByPatientId(
                            CURRENT_USER,
                            CURRENT_REGISTRY_ID,
                            PATIENT_ID);

            // Set the bio followups
            for (int i = 0; i < results.Count; i++)
            {
                results[i].BioFollowUps = VIRP.EFR.BLL.REFERRALManager.GetFollowupActivitiesByReferralId(CURRENT_USER, CURRENT_REGISTRY_ID, results[i].ReferralId);
            }

            // Sort by referral status: EFR_OPEN_CASES; EFR_CLOSED_CASES; EFR_NEW; EFR_INELIGIBLE; anything else

            List<int> statusIds = new List<int> { 98, 99, 91, 101 };

            foreach (int i in statusIds)
            {
                foreach (ReferralsGetListByPatientResult referral in results)
                {
                    if (referral.ReferralStatusId == i)
                    {
                        sortedList.Add(referral);
                    }
                }
            }

            // add any other status's

            foreach (ReferralsGetListByPatientResult referral in results)
            {
                if (referral.ReferralStatusId != 98 &&
                    referral.ReferralStatusId != 99 &&
                    referral.ReferralStatusId != 91 &&
                    referral.ReferralStatusId != 101)
                {
                    sortedList.Add(referral);
                }
            }
            
            return sortedList;
        }

        public static List<VIRP.CRS.BO.WKF_CASE_ACTIVITY> GetFollowupActivitiesByReferralId(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            int referralId)
        {
            var db = new REFERRALDB();

            var results = db.GetFollowupActivitiesByReferralId(
                            CURRENT_USER,
                            CURRENT_REGISTRY_ID,
                            referralId);

            return results;
        }

        public static IEnumerable<ReferralCase> GetCasesByReferralId(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            int referralId)
        {
            var db = new REFERRALDB();

            var results = db.GetCasesByReferralId(
                            CURRENT_USER,
                            CURRENT_REGISTRY_ID,
                            referralId);

            return results;         
        }

        public static IEnumerable<WorkflowcaseActivity> SelectByCaseId(
            string CURRENT_USER,
            Int32 CURRENT_REGISTRY_ID,
            Int32 caseId,
            Int32 caseTypeId)
        {
            var db = new REFERRALDB();

            var results = db.SelectByCaseId(
                            CURRENT_USER,
                            CURRENT_REGISTRY_ID,
                            caseId,
                            caseTypeId);

            bool found = false;
            List<WorkflowcaseActivity> wcaList = new List<WorkflowcaseActivity>();

            // Update each entry if found, and if not, add it.
            var caseTypes = new Dictionary<int, string> { { 1, "Lab Kit" }, { 2, "Questionnaire" }, { 3, "Lab Order" }, { 4, "Lab Result" }, { 22, "Interpretation & Diagnosis" } };

            foreach (var activity in caseTypes)
            {
                found = false;

                for (int i = 0; i < results.Count; i++)
                {
                    if (results[i].CaseActivityTypeId == activity.Key)
                    {
                        results[i].CaseActivityExists = true;
                        wcaList.Add(results[i]);

                        found = true;
                    }
                }

                if (!found)
                {
                    WorkflowcaseActivity wca = new WorkflowcaseActivity();

                    wca.CaseActivityTypeId = activity.Key;
                    wca.CaseActivityExists = false;
                    wca.CaseActivityId = 0;
                    wca.CaseTypeId = caseTypeId;
                    wca.CaseActivityStatus = "N/A";
                    wca.UpdatedDate = "N/A";
                    wca.CaseActivityType = activity.Value;

                    wcaList.Add(wca);
                }
            }

            return wcaList;
        }

        public static int GetFragmentFileCount(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID)
        {
            int? objReturn = 0;

            try
            {
                var db = new REFERRALDB();
                
                objReturn = db.GetFragmentFileCount(
                        CURRENT_USER,
                        CURRENT_REGISTRY_ID,
                        PATIENT_ID);
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return (int)objReturn;
        }

        public static IEnumerable<ReferralFollowUp> GetReferralFollowups(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            string PATIENT_LAST_NAME,
            string SORT_COLUMN,
            int? START_ROW,
            int? MAX_ROWS)
        {
            var db = new REFERRALDB();

            var results = db.GetReferralFollowups(
                CURRENT_USER,
                CURRENT_REGISTRY_ID,
                PATIENT_LAST_NAME,
                SORT_COLUMN,
                START_ROW,
                MAX_ROWS);

            return results;
        }

        public static int GetReferralFollowupsCount(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            string PATIENT_LAST_NAME,
            string SORT_COLUMN,
            int? START_ROW,
            int? MAX_ROWS)
        {
            var db = new REFERRALDB();

            return db.GetReferralFollowupsCount(
                CURRENT_USER,
                CURRENT_REGISTRY_ID,
                PATIENT_LAST_NAME); 
        }

        public static EFR.BO.CONTACT_LOG_PATIENT GetPatientByReferralId(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            int REFERRAL_ID)
        {
            EFR.BO.CONTACT_LOG_PATIENT p = CONTACT_LOGManager.GetItemByReferralId(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID);

            return (p);
        }

        public static IEnumerable<CRS.BO.REFERRAL_LIST> SearchReferrals(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            string REFERRAL_STATUS_CODE,
            string PATIENT_LAST_NAME,
            string SORT_COLUMN,
            int? START_ROW,
            int? MAX_ROWS)
        {
            var db = new REFERRALDB();

            var results = db.SearchReferrals(
                CURRENT_USER,
                CURRENT_REGISTRY_ID,
                REFERRAL_STATUS_CODE,
                PATIENT_LAST_NAME,
                SORT_COLUMN,
                START_ROW,
                MAX_ROWS);

            return results;
        }

        public static int SearchReferralsCount(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            string REFERRAL_STATUS_CODE,
            string PATIENT_LAST_NAME,
            string SORT_COLUMN,
            int? START_ROW,
            int? MAX_ROWS)
        {
            var db = new REFERRALDB();

            return db.SearchReferralsCount(
                CURRENT_USER,
                CURRENT_REGISTRY_ID, 
                REFERRAL_STATUS_CODE,
                PATIENT_LAST_NAME);
        }

        #endregion
    }
}